# import libraries
import numpy as np
from matplotlib import pyplot as plt

# Loading results files
sweep_Pz          = np.loadtxt("resultsR/sweep_Pz.res")
sweep_Pz [:,1]    -= 0.278
sweep_Vz          = np.loadtxt("resultsR/sweep_Vz.res")
sweep_Az          = np.loadtxt("resultsR/sweep_Az.res")

# plotting
f, axarr = plt.subplots(3, sharex=True, num='C')

axarr[0].set_title("Vertical displacement of the wheel centre")
axarr[0].set_ylabel('vertical deflection [m]')
axarr[0].plot(sweep_Pz[:,0], sweep_Pz[:,1])
axarr[0].set_ylim(-0.10,0.10)

axarr[1].set_title("Vertical velocity of the wheel centre")
axarr[1].set_ylabel('vertical velocity [m/s]')
axarr[1].plot(sweep_Vz[:,0], sweep_Vz[:,1])
axarr[1].set_ylim(-10.,10.)

axarr[2].set_title("Vertical acceleration of the wheel centre")
axarr[2].set_ylabel('vertical acceleration [m/s$^{2}$]')
axarr[2].set_xlabel('time [s]')
axarr[2].plot(sweep_Az[:,0], sweep_Az[:,1])
axarr[2].set_ylim(-500,500)


plt.subplots_adjust(left=0.15, bottom=0.07, right=0.85, top=0.96, wspace=None, hspace=0.20)

plt.xlim(0.,20.)
#plt.title("Results Five-Link Suspension")
plt.show()
